-- MySQL phpMyAdmin Yetki ve Veri Kaydetme Kontrolü

-- 1. Kullanıcı yetkilerini kontrol et
SHOW GRANTS FOR 'jouska_user'@'localhost';

-- 2. Veritabanı var mı kontrol et
SHOW DATABASES LIKE 'jouska_db';

-- 3. Tablolar var mı kontrol et
USE jouska_db;
SHOW TABLES;

-- 4. Users tablosuna test verisi ekle
INSERT INTO users (username, password) VALUES ('test_user', 'test_password');

-- 5. Eklenen veriyi kontrol et
SELECT * FROM users WHERE username = 'test_user';

-- 6. Test verisini sil
DELETE FROM users WHERE username = 'test_user';

-- Eğer yukarıdaki komutlar hata veriyorsa:

-- Kullanıcıya tüm yetkileri ver
GRANT ALL PRIVILEGES ON jouska_db.* TO 'jouska_user'@'localhost';
GRANT ALL PRIVILEGES ON jouska_db.* TO 'jouska_user'@'%';
FLUSH PRIVILEGES;

-- Alternatif: Root kullanıcısı ile test
-- CREATE USER 'jouska_user'@'localhost' IDENTIFIED BY 'jouska_2024';
-- GRANT ALL PRIVILEGES ON *.* TO 'jouska_user'@'localhost' WITH GRANT OPTION;
-- FLUSH PRIVILEGES;