import { useQuery } from "@tanstack/react-query";
import { Category } from "@shared/schema";
import { 
  getCachedCategories, 
  cacheCategories
} from "@/lib/offline-storage";

export function useCategories() {
  const query = useQuery<Category[]>({
    queryKey: ['/api/categories'],
    staleTime: 1000 * 60 * 5 // 5 minutes
  });
  
  // Handle success and cache data
  if (query.data && query.data.length > 0) {
    cacheCategories(query.data);
  }
  
  return query;
}
