import React from "react";
import { cn } from "@/lib/utils";

interface SectionTitleProps {
  title: string;
  subtitle?: string;
  centered?: boolean;
  className?: string;
  titleClassName?: string;
  subtitleClassName?: string;
  decorative?: boolean;
  size?: 'sm' | 'md' | 'lg' | 'xl';
}

export const SectionTitle: React.FC<SectionTitleProps> = ({
  title,
  subtitle,
  centered = false,
  className,
  titleClassName,
  subtitleClassName,
  decorative = true,
  size = 'md'
}) => {
  const sizeClasses = {
    sm: {
      container: "mb-4",
      title: "text-xl md:text-2xl mb-1",
      subtitle: "text-sm"
    },
    md: {
      container: "mb-6",
      title: "text-2xl md:text-3xl mb-2",
      subtitle: "text-base"
    },
    lg: {
      container: "mb-8",
      title: "text-3xl md:text-4xl mb-3",
      subtitle: "text-lg"
    },
    xl: {
      container: "mb-10",
      title: "text-4xl md:text-5xl mb-4",
      subtitle: "text-xl"
    }
  };
  
  return (
    <div className={cn(
      sizeClasses[size].container,
      centered && "text-center",
      className
    )}>
      <h2 className={cn(
        "font-display font-bold relative inline-block",
        sizeClasses[size].title,
        titleClassName
      )}>
        {title}
        {decorative && (
          <span className="absolute bottom-0 left-0 w-full transform translate-y-1">
            <span className="block h-1 bg-accent rounded-full" 
                  style={{ width: '60%' }}></span>
            <span className="block h-1 bg-primary rounded-full mt-1" 
                  style={{ width: '40%' }}></span>
          </span>
        )}
      </h2>
      
      {subtitle && (
        <p className={cn(
          "text-muted-foreground font-light",
          sizeClasses[size].subtitle,
          subtitleClassName
        )}>
          {subtitle}
        </p>
      )}
    </div>
  );
};

export default SectionTitle;