import React from "react";
import { Restaurant } from "@shared/schema";

interface FooterProps {
  restaurantInfo?: Restaurant;
}

export const Footer = ({ restaurantInfo }: FooterProps) => {
  // Function to enable admin mode
  const enableAdminMode = () => {
    window.location.href = "/?admin=true";
  };
  
  return (
    <footer className="bg-primary text-primary-foreground py-8 dark:bg-primary/90">
      
      <div className="container mx-auto px-4">
        <div className="flex flex-col md:flex-row justify-between items-center">
          {/* Restaurant information */}
          <div className="mb-6 md:mb-0">
            <div className="flex items-center mb-3">
              <h2 className="font-display text-2xl font-bold text-primary-foreground">
                {restaurantInfo?.name || "Gusto Bistro"}
              </h2>
              <div className="ml-2 text-accent/80 text-sm font-medium bg-white/10 dark:bg-white/20 px-2 py-1 rounded font-condensed">
                EST. 2024
              </div>
            </div>
            
            <div className="space-y-1">
              {restaurantInfo?.address && (
                <p className="text-sm flex items-center">
                  <svg xmlns="http://www.w3.org/2000/svg" className="h-4 w-4 mr-2 text-accent/80" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                  </svg>
                  {restaurantInfo.address}
                </p>
              )}
              
              {restaurantInfo?.phone && (
                <p className="text-sm flex items-center">
                  <svg xmlns="http://www.w3.org/2000/svg" className="h-4 w-4 mr-2 text-accent/80" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                  </svg>
                  {restaurantInfo.phone}
                </p>
              )}
            </div>
          </div>
          
          {/* Hours of operation */}
          <div className="text-center md:text-right bg-white/5 dark:bg-white/10 p-4 rounded-lg">
            <h3 className="font-medium mb-2 border-b border-white/20 dark:border-white/10 pb-1 flex items-center justify-center md:justify-start">
              <svg xmlns="http://www.w3.org/2000/svg" className="h-4 w-4 mr-1 text-accent/80" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
              </svg>
              Çalışma Saatleri
            </h3>
            
            <div className="font-condensed">
              {restaurantInfo?.hoursOfOperation ? (
                restaurantInfo.hoursOfOperation.split('\n').map((line, index) => (
                  <p key={index} className="text-sm opacity-90">{line}</p>
                ))
              ) : (
                <>
                  <p className="text-sm opacity-90">Pazartesi - Cuma: 11:00 - 22:00</p>
                  <p className="text-sm opacity-90">Cumartesi - Pazar: 10:00 - 23:00</p>
                </>
              )}
            </div>
          </div>
        </div>
        
        {/* Copyright section */}
        <div className="border-t border-white/20 dark:border-white/10 mt-8 pt-6 text-center text-sm">
          <p className="flex items-center justify-center gap-2">
            <span>&copy; {new Date().getFullYear()} {restaurantInfo?.name || "Gusto Bistro"}.</span>
            <span className="text-xs bg-white/10 dark:bg-white/20 px-2 py-1 rounded">Tüm hakları saklıdır</span>
          </p>
          
          {/* Hidden admin access button */}
          <button 
            onClick={enableAdminMode}
            className="mt-6 opacity-5 hover:opacity-80 transition-opacity duration-300 text-xs"
            aria-label="Admin Erişimi"
          >
            Admin Erişimi
          </button>
        </div>
      </div>
    </footer>
  );
};
